<?php 
   /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../include/includeBaseComponenti.php";
    include "../../../template/stile.php";
    include "classi/Mappa.php";
    
    if(isset($_GET["id"])) {
        $mappa = new Mappa($geecomDb, filter_input(INPUT_GET, "id",FILTER_SANITIZE_NUMBER_INT));
        $mappa->caricaDatiDalDatabase();
    }
    
    if(isset($_GET["status"])) {
        $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
    }
    else {
        $status = 0;
    }
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "../include/cssBaseComponenti.php";
        ?>
        <title>Geecom CMS - Creazione popup</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "../../include/barraSuperiore.php";

                include "../../include/header.php";

                include "../../include/barraMenu.php";
            ?>
        </header>

        <main role="main" class="bg-light" id="main">
            <div class="container-fluid">
                <div class="row py-4">
                    <?php 
                        if($status==200) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Mappa creata
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                        
                        if($status==220) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Mappa duplicata, modificala per non avere due mappe uguali
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                            <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                        
                        if($status==250) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Mappa modificata
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                    ?>
                    <div class="col-12">
                        <div class="card mb-4 box-shadow-lite">

                            <form name="formComponente" action="controller/controllerComponente.php" method="post">
                                <input type="text" class="d-none" name="operazione" value="<?php echo((isset($mappa) ? "modifica" : "crea")); ?>">
                                <input type="text" class="d-none" name="id" value="<?php echo((isset($mappa) ? $mappa->getId() : "0")); ?>">
                                
                                <div class="card-header">
                                    <div class="row">
                                        <div class="col-12 col-lg-6 d-md-flex">
                                            <h6 class="mt-2 mr-2 text-nowrap">Mappa:</h6>
                                            <input type="text" class="form-control" id="nomeSlider" name="nome" aria-describedby="nome mappa" value="<?php echo((isset($mappa) ? $mappa->getNome() : "")) ?>" placeholder="Nome mappa">
                                        </div>
                                        <div class="col text-right">
                                            <a class="btn btn-outline-primary mt-2 mt-lg-0" href="index.php"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                                            <button class="btn btn-primary mt-2 mt-lg-0" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                                            <button type="button" class="btn btn-warning mt-2 mt-lg-0" onclick="location.href='controller/controllerComponente.php?id=1&amp;operazione=duplica';"><i class="far fa-clone mr-2"></i>Duplica</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-lg-12">
                                                <div class="row">

                                                    <div class="col-md-3 form-group">
                                                        <label for="inputPassword3" >Spazio occupato</label>
                                                        <select class="form-control" name="spazioOccupato">
                                                        <?php 
                                                            foreach($arrayDimensioniColonna as $classe=>$descrizione) {
                                                                if(isset($mappa) && $mappa->getSpazioOccupato()==$classe) {
                                                                    echo"<option value=\"$classe\" selected>$descrizione</option>";
                                                                }
                                                                else {
                                                                    echo"<option value=\"$classe\">$descrizione</option>";
                                                                }
                                                            }
                                                        ?>
                                                        </select>
                                                        <small class="text-muted">Scegli lo spazio che deve occupare la tua form nella sezione</small>
                                                    </div>
                                                    
                                                    <div class="col-md-3 form-group">
                                                        <label for="inputPassword3" >Tipo</label>
                                                        <select class="form-control" name="tipo">
                                                            <?php
                                                                $opzioni = array("Semplice","Avanzata");
                                                                foreach ($opzioni as $opzione) {
                                                                    if(isset($mappa) && $mappa->getTipo()==$opzione) {
                                                                        echo"<option value=\"{$opzione}\" SELECTED>{$opzione}</option>";						
                                                                    }
                                                                    else {
                                                                        echo"<option value=\"{$opzione}\">{$opzione}</option>";
                                                                    }
                                                                }
                                                            ?>
                                                        </select>
                                                        <small class="text-muted">Lo spazio orizzontale occupato dall'elemento</small>
                                                    </div>

                                                    <div class="col-md-3 form-group">
                                                        <label for="inputPassword3" >Indirizzo</label>
                                                        <input type="text" class="form-control" name="indirizzo" value="<?php echo((isset($mappa)) ? $mappa->getIndirizzo() : "") ?>">
                                                        <small class="text-muted">Lo spazio orizzontale occupato dall'elemento</small>
                                                    </div>

                                                    <div class="col-md-3 form-group">
                                                        <label for="inputPassword3" >Latitudine</label>
                                                        <input type="number" step="0.00000001" class="form-control" name="latitudine" value="<?php echo((isset($mappa)) ? $mappa->getLatitudine() : "") ?>">
                                                        <small class="text-muted">Il link a cui reindirizzerà la popup</small>
                                                    </div>

                                                    <div class="col-md-3 form-group">
                                                        <label for="inputPassword3" >Longitudine</label>
                                                        <input type="number" step="0.00000001" class="form-control" name="longitudine" value="<?php echo((isset($mappa)) ? $mappa->getLongitudine() : "") ?>">
                                                        <small class="text-muted">Il link a cui reindirizzerà la popup</small>
                                                    </div>                                                  
                                                    
                                                    <div class="form-group col-12">
                                                        <textarea class="form-control" name="html" rows="10"><?php echo(isset($mappa) ? $mappa->getHtml() : "") ?></textarea>
                                                    </div>

                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            <div class="card-footer">
                                <button type="button" class="btn btn-primary float-right" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>

        <?php
            include "../../include/footer.php";

            include "../include/modal/cambiaPassword.php";
            
            include "../include/modal/eliminaElemento.php";

            include "../../include/modal/modalMenuComponenti.php";

            include "../../include/modal/operazioneCompletata.php";

            include "../include/jsBaseComponenti.php";
        ?>

        <!-- Dropzone -->
        <script type="text/javascript" src="../../../plugins/dropzone/dropzone.js"></script>
        <script>
            $("#frmFileUpload-00").dropzone({
                acceptedFiles: ".jpeg,.jpg,.png,.gif,.svg",
                maxFiles: 1,
                addRemoveLinks: true,
                dictRemoveFile: "Rimuovi",
                success: function(file,response) {
                    document.getElementById("immagineElemento").src=response;
                    this.removeAllFiles();
                },
                params:{
                    operazione:"modificaImmagine",
                    id:<?php echo $mappa->getId() ?>
                },
                maxfilesexceeded: function(file) {
                    this.removeAllFiles();
                    this.addFile(file);
                }
            })
        </script>
    </body>
</html>
